/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Strings
 */

#include "strings.h"

/* Convert string to lowercase (not quite right this way, but is only used for
 * keywords anyway) */
static void FN_String_ToLower(ListItem *p, int len) {
  int a;

  for(a = 0; a < len; a++) p->String[a] |= 32;
}

/* Show copyright message if not already shown */
static void FN_String_ShowCopyright() {
  if((ffProgram & FCOPYRIGHTSHOWN) == 0) {
    ffProgram |= FCOPYRIGHTSHOWN;
    printf(psCopyright);
  }
}

/* Show copyright and usage message if not already shown */
static void FN_String_ShowUsage() {
  FN_String_ShowCopyright();
  if((ffProgram & FUSAGESHOWN) == 0) {
    ffProgram |= FUSAGESHOWN;
    printf(psUsage);
  }
}
